(function($) {
	
	
	
	//Cache jQuery Selector
	var $window		= $(window),
		$loaderout	= $('.preloader'),				// 0. Preloader For Hide loader
		$carousel	= $('.carousel'),   			// 1. Bootstrap slider pause time
		$dropdown	= $('.dropdown'),				// 2. dropdown submenu on hover in desktopand dropdown sub menu on click in mobile
		$header		= $('#header'),					// 3. Update Header Style + Scroll to Top
		$projectimg	= $('.project-images'),			// 4. Single project slider click + Show large image in top box
		$engineer	= $('.our-engineer'),			// 7. Our Engineers Carousel
		$client		= $('.testimonials-carousel'),	// 8. Testimonials Carousel Slider
		$sidebar	= $('.feedback-sidebar'),		// 9. Testimonials Carousel in sidebar small
		$const		= $('.under-construction'),		// 10. Under Construction Carousel Slider
		$rpost		= $('.rltd-post'),				// 11. Related post slider at single blog page
		$projectnav	= $('.project-thumbnail'),		// 12. Project image view slider carosure nav image slide
		$brand		= $('.partner-slider'),			// 13. Our Partner Logos Slider Auto
		$experience	= $('.project-experience'),		// 14. Project Experience Carousel "in engineer profile page"
		$contact	= $('#contact-form')			// 23. Contact Form Validation
	
	
	
	/* Table of jQuery settings list
		
		0. Preloader For Hide loader
		1. Bootstrap slider pause time
		2. dropdown submenu on hover in desktopand dropdown sub menu on click in mobile
		3. Update Header Style + Scroll to Top
		4. Single project slider click + Slide image event
		5. Submenu Dropdown Toggle
		6. Revolution Slider
		7. Our Engineers Carousel
		8. Testimonials Carousel Slider
		9. Testimonials Carousel in sidebar small
		10. Under Construction Carousel Slider
		11. Related post slider at single blog page
		12. Project image view slider carosure nav image slide
		13. Our Partner Logos Slider Auto
		14. Project Experience Carousel "in engineer profile page"
		15. Accordion Box
		16. Fact Counter For Achivement Counting
		17. LightBox / Fancybox
		18. Sortable Masonary with Filters
		19. Gallery With Filters List
		20. Date Picker
		21. Scroll to a Specific Div
		22. Click Search Icon and Open Search Field
		23. Contact Form Validation
		24. Elements Animation
		25. When document is Scrollig, do
		26. When document is loading, do
	
	*/
	
	
	
	
	// 0. Preloader For Hide loader
	function handlePreloader() {
		if($loaderout.length){
			$loaderout.delay(500).fadeOut(500);
		}
	}
		
	
	
	// 1. Bootstrap slider pause time
	$('.carousel').carousel({
	  interval: 6000,  // Slider Pause time
	  pause: "hover"
	});
	
	
	// 2. dropdown submenu on hover in desktopand dropdown sub menu on click in mobile
	$('#bs-example-navbar-collapse-1').each(function() {		
		$dropdown.on('show.bs.dropdown', function(e){
			if($window.width() < 992) {
				$(this).find('.dropdown-menu').first().stop(true, true).slideDown(300);
			}
			else{
				return false;
			}
		});
		
		$dropdown.on('hide.bs.dropdown', function(e){
			if($window.width() < 992) {
				$(this).find('.dropdown-menu').first().stop(true, true).slideUp(200);
			}
			else{
				return false;
			}
		});			
	});
	
	
	
	// 3. Update Header Style + Scroll to Top
	function headerStyle() {
		if($header.length){
			var windowpos = $window.scrollTop();
			if (windowpos >= 130) {
				$header.addClass('fixed-header');
			} else {
				$header.removeClass('fixed-header');
			}
		}
	}
	
	
	// 4. Single project slider click + Show large image in top box
	$projectimg.each(function() {
		$(this).on('click','.item a',function(event) {
			event.preventDefault();
			$(this).parents('.project-images').find(".item a").removeClass('onlive');
			$(this).addClass('onlive');
			$(this).parents('.project-images').find(".slide-project img").attr("src", $(this).attr("href"));
		});
	});
	
	// 5. Submenu Dropdown Toggle
	if($('.main-menu li.dropdown ul').length){
		$('.main-menu li.dropdown').append('<div class="dropdown-btn"></div>');
		
		//Dropdown Button
		$('.main-menu li.dropdown .dropdown-btn').on('click', function() {
			$(this).prev('ul').slideToggle(500);
		});
		
		//Disable dropdown parent link
		$('.navigation li.dropdown > a').on('click', function(e) {
			e.preventDefault();
		});
	}
	
	
	
	// 6. Revolution Slider
	if($('.revolution-slider .tp-banner').length){

		jQuery('.revolution-slider .tp-banner').show().revolution({
		  
		  delay:10000,
		  startwidth:1200,
		  startheight:720,
		  hideThumbs:600,
	
		  thumbWidth:80,
		  thumbHeight:50,
		  thumbAmount:5,
	
		  navigationType:"bullet",
		  navigationArrows:"0",
		  navigationStyle:"preview4",
	
		  touchenabled:"on",
		  onHoverStop:"off",
	
		  swipe_velocity: 0.7,
		  swipe_min_touches: 1,
		  swipe_max_touches: 1,
		  drag_block_vertical: false,
	
		  parallax:"mouse",
		  parallaxBgFreeze:"on",
		  parallaxLevels:[7,4,3,2,5,4,3,2,1,0],
	
		  keyboardNavigation:"off",
	
		  navigationHAlign:"center",
		  navigationVAlign:"bottom",
		  navigationHOffset:0,
		  navigationVOffset:20,
	
		  soloArrowLeftHalign:"left",
		  soloArrowLeftValign:"center",
		  soloArrowLeftHOffset:20,
		  soloArrowLeftVOffset:0,
	
		  soloArrowRightHalign:"right",
		  soloArrowRightValign:"center",
		  soloArrowRightHOffset:20,
		  soloArrowRightVOffset:0,
	
		  shadow:0,
		  fullWidth:"on",
		  fullScreen:"off",
	
		  spinner:"spinner4",
	
		  stopLoop:"off",
		  stopAfterLoops:-1,
		  stopAtSlide:-1,
	
		  shuffle:"off",
	
		  autoHeight:"off",
		  forceFullWidth:"on",
	
		  hideThumbsOnMobile:"on",
		  hideNavDelayOnMobile:1500,
		  hideBulletsOnMobile:"on",
		  hideArrowsOnMobile:"on",
		  hideThumbsUnderResolution:0,
	
		  hideSliderAtLimit:0,
		  hideCaptionAtLimit:0,
		  hideAllCaptionAtLilmit:0,
		  startWithSlide:0,
		  videoJsPath:"",
		  fullScreenOffsetContainer: ""
	  });

		
	}
	
	
	// 7. Our Engineers Carousel
	if ($engineer.length) {
		$engineer.owlCarousel({
			loop:true,
			margin:30,
			nav:true,
			smartSpeed: 500,
			autoplay: false,
			navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
			responsive:{
				0:{
					items:1
				},
				600:{
					items:2
				},
				1024:{
					items:3
				},
				1200:{
					items:4
				}
			}
		});    		
	}
	
	
	// 8. Testimonials Carousel Slider
	if ($client.length) {
		$client.owlCarousel({
			loop:true,
			margin:30,
			nav:true,
			autoplayHoverPause:false,
			autoplay: 5000,
			smartSpeed: 700,
			navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
			responsive:{
				0:{
					items:1
				},
				600:{
					items:1
				},
				760:{
					items:2
				},
				1024:{
					items:2
				},
				1200:{
					items:2
				}
			}
		});    		
	}
	
	// 9. Testimonials Carousel in sidebar small
	if ($sidebar.length) {
		$sidebar.owlCarousel({
			loop:true,
			margin:30,
			nav:true,
			autoplayHoverPause:true,
			autoplay: 5000,
			smartSpeed: 700,
			navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
			responsive:{
				0:{
					items:1
				},
				600:{
					items:1
				},
				760:{
					items:1
				},
				1024:{
					items:1
				},
				1200:{
					items:1
				}
			}
		});    		
	}
	
	// 10. Under Construction Carousel Slider
	if ($const.length) {
		$const.owlCarousel({
			loop:true,
			margin:30,
			nav:true,
			autoplayHoverPause:false,
			autoplay: false,
			smartSpeed: 700,
			navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
			responsive:{
				0:{
					items:1
				},
				600:{
					items:1
				},
				760:{
					items:2
				},
				1024:{
					items:2
				},
				1100:{
					items:2
				}
			}
		});    		
	}
	
	// 11. Related post slider at single blog page
	if ($rpost.length) {
		$rpost.owlCarousel({
			loop:true,
			margin:15,
			nav:true,
			autoplayHoverPause:false,
			autoplay: false,
			smartSpeed: 700,
			navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
			responsive:{
				0:{
					items:1
				},
				600:{
					items:1
				},
				760:{
					items:2
				},
				1024:{
					items:2
				},
				1100:{
					items:2
				}
			}
		});    		
	}
	
	
	// 12. Project image view slider carosure nav image slide
	if ($projectnav.length) {
		$projectnav.owlCarousel({
			loop:false,
			margin:30,
			nav:true,
			autoplayHoverPause:false,
			autoplay: false,
			smartSpeed: 700,
			navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
			responsive:{
				0:{
					items:3
				},
				600:{
					items:4
				},
				760:{
					items:5
				},
				1024:{
					items:5
				},
				1100:{
					items:7
				}
			}
		});    		
	}
	
	
	// 13. Our Partner Logos Slider Auto
	if ($brand.length) {
		$brand.owlCarousel({
			loop:true,
			margin:30,
			nav:true,
			smartSpeed: 500,
			autoplay: 4000,
			navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
			responsive:{
				0:{
					items:1
				},
				480:{
					items:2
				},
				600:{
					items:3
				},
				800:{
					items:4
				},
				1200:{
					items:5
				}
			}
		});    		
	}
	
	
	// 14. Project Experience Carousel "in engineer profile page"
	if ($experience.length) {
		$experience.owlCarousel({
			loop:true,
			margin:15,
			nav:true,
			smartSpeed: 500,
			autoplay: 4000,
			navText: [ '<i class="fa fa-angle-left"></i>', '<i class="fa fa-angle-right"></i>' ],
			responsive:{
				0:{
					items:1
				},
				480:{
					items:2
				},
				600:{
					items:3
				},
				800:{
					items:4
				},
				1200:{
					items:4
				}
			}
		});    		
	}
	
	
	// 15. Accordion Box
	if($('.accordion-box').length){
		$(".accordion-box").on('click', '.accord-btn', function() {
		
			if($(this).hasClass('active')!==true){
				$('.accordion .accord-btn').removeClass('active');			
			}
			
			if ($(this).next('.accord-content').is(':visible')){
				$(this).removeClass('active');
				$(this).next('.accord-content').slideUp(300);
			}
			else{
				$(this).addClass('active');
				$('.accordion .accord-content').slideUp(300);
				$(this).next('.accord-content').slideDown(300);	
			}
		});	
	}
	
	
	
	// 16. Fact Counter For Achivement Counting
	function factCounter() {
		if($('.fact-counter').length){
			$('.fact-counter .count.animated').each(function() {
		
				var $t = $(this),
					n = $t.find(".count-num").attr("data-stop"),
					r = parseInt($t.find(".count-num").attr("data-speed"), 10);
					
				if (!$t.hasClass("counted")) {
					$t.addClass("counted");
					$({
						countNum: $t.find(".count-text").text()
					}).animate({
						countNum: n
					}, {
						duration: r,
						easing: "linear",
						step: function() {
							$t.find(".count-num").text(Math.floor(this.countNum));
						},
						complete: function() {
							$t.find(".count-num").text(this.countNum);
						}
					});
				}
				
				//set skill building height


					var size = $(this).children('.progress-bar').attr('aria-valuenow');
					$(this).children('.progress-bar').css('width', size+'%');

				
			});
		}
	}
	
	
	// 17. LightBox / Fancybox
	if($('.lightbox-image').length) {
		$('.lightbox-image').fancybox({
			openEffect  : 'elastic',
			closeEffect : 'elastic',
			helpers : {
				media : {}
			}
		});
	}
	
	
	// 18. Sortable Masonary with Filters
	function enableMasonry() {
		if($('.sortable-masonry').length){
	
			var winDow = $(window);
			// Needed variables
			var $container=$('.sortable-masonry .items-container');
			var $filter=$('.sortable-masonry .filter-btns');
	
			$container.isotope({
				filter:'*',
				 masonry: {
					columnWidth : 1 
				 },
				animationOptions:{
					duration:1000,
					easing:'linear'
				}
			});
			
	
			// Isotope Filter 
			$filter.find('li').on('click', function(){
				var selector = $(this).attr('data-filter');
	
				try {
					$container.isotope({ 
						filter	: selector,
						animationOptions: {
							duration: 1000,
							easing	: 'linear',
							queue	: false
						}
					});
				} catch(err) {
	
				}
				return false;
			});
	
	
			winDow.bind('resize', function(){
				var selector = $filter.find('li.active').attr('data-filter');

				$container.isotope({ 
					filter	: selector,
					animationOptions: {
						duration: 1000,
						easing	: 'linear',
						queue	: false
					}
				});
			});
	
	
			var filterItemA	= $('.sortable-masonry .filter-btns li');
	
			filterItemA.on('click', function(){
				var $this = $(this);
				if ( !$this.hasClass('active')) {
					filterItemA.removeClass('active');
					$this.addClass('active');
				}
			});
		}
	}
	
	enableMasonry();
	
	
	
	// 19. Gallery With Filters List
	if($('.filter-list').length){
		$('.filter-list').mixItUp({});
	}
	
	
	// 20. Date Picker
	  if($('.datepicker').length){
		$( ".datepicker" ).datepicker();
	  }
	
	
	// 21. Scroll to a Specific Div
	if($('.scroll-to-target').length){
		$(".scroll-to-target").on('click', function() {
			var HeaderHeight = $('.header-lower').height();
			var target = $(this).attr('data-target');
		   // animate
		   $('html, body').animate({
			   scrollTop: $(target).offset().top - HeaderHeight
			 }, 1000);
	
		});
	}
	
	
	// 22. Click Search Icon and Open Search Field	
	var $srcicon = $('.hvr-src a'),
		$srcfield = $('#search');
	$srcicon.on('click', function(event){
		event.preventDefault();
		$srcfield.addClass('visible');
		event.stopPropagation();
	});
	
	$('.src-close').on('click', function(){
		$srcfield.removeClass('visible');
	});
	
	$srcfield.on('click', function(event){
		event.stopPropagation();
	});
	
	$window.on('click', function(e){
		$srcfield.removeClass('visible');
	});
	
	
	// 23. Contact Form Validation
	if($contact.length){
		$contact.validate({  //#contact-form contact form id
			rules: {
				first: {
					required: true    // Field name here
				},
				email: {
					required: true, // Field name here
					email: true
				},
				subject: {
					required: true
				},
				message: {
					required: true
				}
			},
			
			messages: {
                first: "Please enter First Name", //Write here your error message that you want to show in contact form
                email: "Please enter valid Email", //Write here your error message that you want to show in contact form
                subject: "Please enter your Subject", //Write here your error message that you want to show in contact form
				message: "Please write your Message" //Write here your error message that you want to show in contact form
            },

            submitHandler: function (form) {
                $('#send').attr({'disabled' : 'true', 'value' : 'Sending...' });
                $.ajax({
                    type: "POST",
                    url: "email.php",
                    data: $(form).serialize(),
                    success: function () {
                        $('#send').removeAttr('disabled').attr('value', 'Send');
                        $( "#success").slideDown( "slow" );
                        setTimeout(function() {
                        $( "#success").slideUp( "slow" );
                        }, 5000);
                        form.reset();
                    },
                    error: function() {
                        $('#send').removeAttr('disabled').attr('value', 'Send');
                        $( "#error").slideDown( "slow" );
                        setTimeout(function() {
                        $( "#error").slideUp( "slow" );
                        }, 5000);
                    }
                });
                return false; // required to block normal submit since you used ajax
            }

		});
	} 

	
	
	// 24. Elements Animation
	if($('.wow').length){
		var wow = new WOW(
		  {
			boxClass:     'wow',      // animated element css class (default is wow)
			animateClass: 'animated', // animation css class (default is animated)
			offset:       0,          // distance to the element when triggering the animation (default is 0)
			mobile:       true,       // trigger animations on mobile devices (default is true)
			live:         true       // act on asynchronously loaded content (default is true)
		  }
		);
		wow.init();
	}

/* ==========================================================================
   25. When document is Scrollig, do
   ========================================================================== */
	
	$window.on('scroll', function() {
		headerStyle();
		factCounter();
	});
	
/* ==========================================================================
   26. When document is loading, do
   ========================================================================== */
	
	$window.on('load', function() {
		handlePreloader();
		enableMasonry();
	});
	
	

	

})(window.jQuery);